/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class VWCorrelationSetPropertiesTableModel
extends AbstractTableModel {
    public static final int NUM_COLUMNS = 2;
    public static final int COL_NAME = 0;
    public static final int COL_XPATH_QUERY_STRING = 1;
    protected Vector m_rowData = null;
    protected VWAuthPropertyData m_authPropertyData = null;
    protected VWInstructionDefinition m_instructionDef = null;
    private String m_value = "";

    public VWCorrelationSetPropertiesTableModel(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_rowData = new Vector();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize(VWInstructionDefinition instructionDef) {
        try {
            int count;
            this.m_instructionDef = instructionDef;
            this.m_rowData.removeAllElements();
            String[][] parameters = this.getParameters();
            if (parameters != null && (count = parameters.length) > 0) {
                for (int i = 0; i < count; ++i) {
                    this.m_rowData.addElement(parameters[i]);
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void copy(int row) {
        block3: {
            String[] parameter = null;
            String[] newParameter = null;
            try {
                parameter = this.getItemAt(row);
                if (parameter != null && this.m_authPropertyData != null) {
                    String name = VWResource.s_copyOfFieldName.toString(parameter[0]);
                    newParameter = new String[]{name, parameter[1]};
                    this.m_rowData.addElement(newParameter);
                    this.updateInstruction();
                    row = this.getRowCount() - 1;
                    this.fireTableRowsInserted(row, row);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block3;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void delete(int row) {
        String[] parameter = null;
        try {
            parameter = this.getItemAt(row);
            if (parameter != null && this.m_authPropertyData != null) {
                this.m_rowData.removeElementAt(row);
                this.updateInstruction();
                this.fireTableRowsDeleted(row, row);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_nameStr;
            }
            case 1: {
                return VWResource.s_xpathQueryString;
            }
        }
        return null;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowData.size() + 1;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public String[] getItemAt(int row) {
        String[] result = null;
        if (row >= 0 && row < this.m_rowData.size()) {
            result = (String[])this.m_rowData.elementAt(row);
        }
        return result;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            String[] parameter = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (parameter != null) {
                        return parameter[0];
                    }
                    return "";
                }
                case 1: {
                    if (parameter != null) {
                        return parameter[1];
                    }
                    return this.m_value;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 0: {
                    this.onUpdateName(aValue, nRowIndex);
                    break;
                }
                case 1: {
                    this.onUpdateValue(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected abstract void updateInstruction();

    protected abstract String[][] getParameters();

    private void onUpdateName(Object value, int row) {
        try {
            if (value != null) {
                String[] parameter = this.getItemAt(row);
                if (parameter != null) {
                    parameter[0] = (String)value;
                    this.m_rowData.setElementAt(parameter, row);
                    this.updateInstruction();
                    this.fireTableCellUpdated(row, 0);
                } else {
                    parameter = new String[]{(String)value, this.m_value};
                    this.m_rowData.addElement(parameter);
                    this.updateInstruction();
                    this.fireTableRowsInserted(row + 1, row + 1);
                    this.m_value = "";
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateValue(Object value, int row) {
        try {
            if (value != null) {
                String[] parameter = this.getItemAt(row);
                if (parameter != null) {
                    parameter[1] = (String)value;
                    this.m_rowData.setElementAt(parameter, row);
                    this.updateInstruction();
                } else {
                    this.m_value = (String)value;
                }
                this.fireTableCellUpdated(row, 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

